/***************************************************************/
//
//
//		DirectX 3D RENDER SAMPLE	[main.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 10/19
/*---------------------------------------------------------------
Update : 2016/10/19
		FVF̕ύX
			D3DFVF_XYZRHW -> D3DFVF_XYZ
		VERTEX\̂rhw̍폜
		J̒ǉ,
		Cg̒ǉ,

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include <Windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "main.h"
#include "resource.h"
#include <commdlg.h>
#include "tool_proc.h"
#include "particle_panel.h"
#include "dome_panel.h"

#include "polygon.h"
#include "field.h"
#include "wall.h"
#include "dome.h"
#include "model.h"
#include "billboard.h"

#include "controller.h"
#include "emitter.h"
#include "shadow.h"
#include "particle.h"

#include "d_manager.h"
#include "d_console.h"
#include "d_log.h"

#include "camera.h"
#include "light.h"
#include "mouse.h"

#include "input.h"

#ifdef _DEBUG
#include "debug.h"
#endif	// _DEBUG

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define CLASS_NAME "Particle Emitter 3D"					// EBhENX̖O

#define TIMER_INTERVAL (1000/60)							// Ԋu601b

#define WIN_STYLE ( WS_OVERLAPPEDWINDOW \
	^ (WS_THICKFRAME & WS_SIZEBOX) )	// windowstylẽ}N

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
	
LRESULT CALLBACK WndProc(HWND hWnd,							// EBhEvV[W
UINT uMsg,WPARAM wParam,LPARAM lParam);

void MenuProcess( HWND hWnd, WPARAM wParam );
void StartUpLoadFileProcess( LPTSTR IpCmdLine );
void DropFileProcess( WPARAM wParam );

HRESULT Init(												// DirectX9̏ݒ
HINSTANCE hInstance,
HWND hWnd,
BOOL bWindow);

void UnInit(void);											// I
void Update( void );										// XV
void Draw ( void );											// ʂ̕`

#ifdef _DEBUG
void DrawFPS( void );										// FPS\p
#endif

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3D9       g_pD3D       = nullptr;
LPDIRECT3DDEVICE9 g_pD3DDevice = nullptr;			// Direct3DfoCXC^[tF[X̎擾

int g_nCountFPS = 0;								// FPSJEgp

D3DXCOLOR screenClearColor = D3DCOLOR_RGBA(192,192,192,0);

#ifdef _DEBUG
bool WIRE_FRAME = false;							// C[t[`ptO
#endif

// Ήgq
const char* FORMAT_EMITTER[ ] ={
	".bin"
};

const char* FORMAT_XFILE[ ] ={
	".x"
};

const int FORMAT_NUMBER = 5;
const char* FORMAT_TEXTURE[ ] ={
	".jpg",
	".png",
	".tga",
	".bmp",
	".dds"
};


//	WinMain֐
int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPravInstance, LPTSTR IpCmdLine, int nCmdShow )
{


	// THIS APPLICATION DONT USE STATUS 
	UNREFERENCED_PARAMETER( hPravInstance );

	WNDCLASSEX wcex = {
		sizeof( WNDCLASSEX ),						// WNDCALSSEX̃TCYw
		CS_CLASSDC,									// \EBhẼX^Cݒ
		WndProc,									//   vg^Cv錾֐Ŏw
		0,											// ʏ͎gpȂ̂"0"w
		0,											// ʏ͎gpȂ̂"0"wx
		hInstance,									//   WinMaiñp[^̃CX^Xnhݒ
		LoadIcon(hInstance, TEXT("KITTY")),			// gpACRw(WindowĂACRg)
		LoadCursor(NULL, IDC_CROSS),				// }EXJ[\w
		(HBRUSH)(COLOR_WINDOW + 1),					// EBhẼNCAg̈̔wiFݒ
		MAKEINTRESOURCE(IDR_MENU1),					// Windowsɂ郁j[ݒ
		CLASS_NAME,									//   EBhENX̖O
		NULL										// ACRݒ肳ꂽꍇ̏Lq
	};

	// EBhENX̓o^
	RegisterClassEx(&wcex);

	HWND hWnd;
	MSG msg;		

	RECT cr = { 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT };
	AdjustWindowRect( &cr, WIN_STYLE, FALSE );

	RECT dr = {};
	GetWindowRect( GetDesktopWindow( ),&dr );
	int windowX = (cr.right-cr.left)>(dr.right-dr.left) ? 0:((dr.right-dr.left)-(cr.right-cr.left))/2;
	int windowY = (cr.bottom-cr.top)>(dr.bottom-dr.top) ? 0:((dr.bottom-dr.top)-(cr.bottom-cr.top))/2;

	// EBhE쐬
	hWnd = CreateWindowEx(
	WS_EX_ACCEPTFILES,								// gEBhEX^C
	CLASS_NAME,										// EBhENX̖O
	WINDOW_NAME,									// EBhE̖O
	WIN_STYLE,										// EBhEX^C
	windowX,										// EBhE̍XW
	windowY,										// EBhE̍YW
	cr.right-cr.left,								// EBhE̕
	cr.bottom-cr.top,								// EBhE̍
	NULL,											// eEBhẼnh
	NULL,											// j[nh܂͎qEBhEID
	hInstance,										// CX^Xnh
	NULL);											// EBhE쐬f[^

	// DirectX
	Init( hInstance, hWnd, true );

	// t@C̓ǂݍ݂ꍇ
	StartUpLoadFileProcess( IpCmdLine );

	// EBhE̕\
	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

	// \̐ݒ
	timeBeginPeriod( 1 );

	// eJE^[̏
	DWORD dwFrameCount = 0;
	DWORD dwCurrentTime = 0;
	DWORD dwExecLastTime = timeGetTime();			// ݂̎~bPʂŎ擾
	DWORD dwFPSLastTime = dwExecLastTime;			// Ԃ𓯊
		
	//bZ\W[v
	for(;;){
		if( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE)!=0 ){
			//windows̏
			if(msg.message==WM_QUIT){
				break;
			}
			else{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else{
			dwCurrentTime = timeGetTime();		// ݂̎~bPʂŎ擾
			
			if( (dwCurrentTime-dwFPSLastTime) >= 500 ){

				g_nCountFPS=(dwFrameCount*1000)/(dwCurrentTime-dwFPSLastTime);
				dwFPSLastTime = dwCurrentTime;
				dwFrameCount=0;
			}
			if( (dwCurrentTime - dwExecLastTime) >= ( TIMER_INTERVAL ) ){
				// DirectX̏
				dwExecLastTime=dwCurrentTime;	// Ԃۑ
				Update();						// XV
				Draw();							// `
				dwFrameCount++;
			}
		}
	}

	// I
	UnInit( );

	// ȑOɃZbgꂽŏ^C}\NA
	timeEndPeriod( 1 );

	return (int)msg.wParam;		// ֐0Ԃ

}

// EBhEvV[W
LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{

	switch( uMsg ){

		case WM_CLOSE:
			if( IDNO == MessageBox(NULL,"I܂H",WINDOW_NAME, MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2 ))
				uMsg = 0;
			break;

		case WM_DESTROY:
			PostQuitMessage(0);			// "WM_QUIT"bZ[WԂ	
			break;

		case WM_CREATE:{
				// HINSTANCE̎擾
				HINSTANCE hInstance = (HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );

				// _CAO{bNX̕\
				HWND dlgWnd = CreateDialog( hInstance, MAKEINTRESOURCE(IDD_DIALOG1), hWnd,(DLGPROC)EditEmitterDlgProc );
				ShowWindow( dlgWnd, SW_SHOW );
				UpdateWindow( dlgWnd );
			}break;

		case WM_COMMAND:
			MenuProcess( hWnd, wParam );
			break;

		case WM_DROPFILES:{
			DropFileProcess( wParam );
			}break;

		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					if( IDYES == MessageBox(NULL,"I܂H",WINDOW_NAME, MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2 )){
						DestroyWindow( hWnd );
					}
					break;
				default:
					break;
			}
			break;
		default:
			break;
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

// MENU PROCESS
void MenuProcess( HWND hWnd, WPARAM wParam )
{

	switch( LOWORD( wParam ) ){

	case ID_40018:
		g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);
		break;
	case ID_40019:
		g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);
		break;
	case ID_40021:
		g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_POINT);
		break;
	case ID_40022:
		g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DSHADE_FORCE_DWORD);
		break;
	case ID_40024:
		InitCamera( );
		break;
	case ID_40025:{

			// HINSTANCE̎擾
			HINSTANCE hInstance = (HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );

			// _CAO{bNX̕\
			HWND dlgWnd = CreateDialog( hInstance, MAKEINTRESOURCE(IDD_DIALOG1), hWnd,(DLGPROC)EditEmitterDlgProc );
			EmitterUpdateFrag( true );
			ShowWindow( dlgWnd, SW_SHOW );

		}break;
	case ID_40035:{
			// HINSTANCE̎擾
			HINSTANCE hInstance = (HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );

			int DIALOG_ID = IDD_DIALOG2;

			// _CAO{bNX̕\
			HWND dlgWnd = CreateDialog( hInstance, MAKEINTRESOURCE(DIALOG_ID), hWnd,(DLGPROC)EditPtclPanelDlgProc );
			PtclPanelUpdateFrag( true );
			ShowWindow( dlgWnd, SW_SHOW );
		}break;
	case ID_40029:{
			// HINSTANCE̎擾
			HINSTANCE hInstance = (HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );

			// _CAO{bNX̕\
			HWND dlgWnd = CreateDialog( hInstance, MAKEINTRESOURCE(IDD_DIALOG3), hWnd,(DLGPROC)EditDomeDlgProc );
			DomeUpdateFrag( true );
			ShowWindow( dlgWnd, SW_SHOW );
		}break;
	case ID_40002:{

			// t@CI[v_CAO{bNX̃eXg
			FILE* pfile;
			OPENFILENAME ofn;
			char szFile[260];
			char strMsg[250];

			lstrcpy( szFile, "*.bin" );

			ZeroMemory(&ofn, sizeof(ofn));
			ofn.lStructSize = sizeof(ofn);
			ofn.hwndOwner = NULL;
			ofn.lpstrFile = szFile;
			ofn.nMaxFile = sizeof(szFile);
			ofn.lpstrFilter = " Format BIN \0*.bin\0Gif Format\0*.gif\0All\0*.*\0";
			ofn.nFilterIndex = 1;
			ofn.lpstrFileTitle = NULL;
			ofn.nMaxFileTitle = 0;
			ofn.lpstrInitialDir = NULL;
			ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

			if( !GetOpenFileName(&ofn) ){
				MessageBox(NULL, "t@CIĂ܂",WINDOW_NAME, MB_OK | MB_ICONSTOP);
			}else{
				wsprintf(strMsg, "t@CI܂B\nt@C\n%s\nłB",
						 szFile);
				MessageBox(NULL, strMsg, WINDOW_NAME, MB_OK | MB_ICONINFORMATION);

				char filename[255] = { };		// t@Cl[
				char extension[255] ={ };		// gq

				// pX̐؂o
				_splitpath(  &ofn.lpstrFile[0], NULL, NULL, filename, extension );
		
				// t@Cl[̏o
				sprintf(  &ofn.lpstrFile[0], "%s%s", filename , extension );

				// t@CI[v
				pfile = fopen( &ofn.lpstrFile[0] , "rb" );
				if( !pfile ){
					MessageBox(NULL, "EMIITER LOAD ERROR !!", WINDOW_NAME, MB_OK | MB_ICONINFORMATION);
					exit(EXIT_FAILURE);
				}
		
				EMITTER* emitter = GetEmitter( );
				int      index   = GetEmitterIndex( );

				// EMITTERǂݍ
				fread( &emitter[index], sizeof( EMITTER ), 1, pfile );
				fread( &PARTICLE::AMBIENT, sizeof(D3DXVECTOR3), 1, pfile );
				fread( &PARTICLE::GRAVITY, sizeof(D3DXVECTOR3), 1, pfile );
				fread( &PARTICLE::ROTATION, sizeof(D3DXVECTOR3), 1, pfile );

				fclose( pfile );
				
				EmitterUpdateFrag( true );
				PtclPanelUpdateFrag( true );

			}
		}break;
	case ID_40004:{
		}break;
	case ID_40031:
		SetEmitter( );
		break;
	case ID_40032:{
		FILE *pfile;			// t@C|C^
		time_t timer;			// ̎擾
		SYSTEMTIME ctime;		// ̎擾
		struct tm *t_st;
		char FILE_NAME[256]  = { };
		char MESSAGE[256]    = { };

		// ݎ̎擾
		time(&timer);
		t_st = localtime(&timer);
		GetLocalTime( &ctime );

		// t@Cl[̏
		sprintf( FILE_NAME, "emitter%04d%02d%02d%02d%02d%02d", t_st->tm_year+1900, t_st->tm_mon+1, t_st->tm_mday, (int)ctime.wHour, (int)ctime.wMinute, (int)ctime.wSecond );
		//sprintf( FILE_NAME, "emitter%4d%2d%2d", t_st->tm_year+1900, t_st->tm_mon+1, t_st->tm_mday );

		// t@C̍쐬
		sprintf( FILE_NAME, "%s.bin\0",FILE_NAME );

		// cppfileI[v
		pfile = fopen( &FILE_NAME[0] , "wb" );

		EMITTER* emitter = GetEmitter( );
		int      index   = GetEmitterIndex( );

		// EMITTER񏑂
		fwrite( &emitter[index], sizeof( EMITTER ), 1, pfile );
		fwrite( &PARTICLE::AMBIENT, sizeof(D3DXVECTOR3), 1, pfile );
		fwrite( &PARTICLE::GRAVITY, sizeof(D3DXVECTOR3), 1, pfile );
		fwrite( &PARTICLE::ROTATION, sizeof(D3DXVECTOR3), 1, pfile );

		fclose( pfile );
			
		sprintf( MESSAGE, "%sŕۑ܂", FILE_NAME );
		MessageBox( NULL, MESSAGE, WINDOW_NAME, MB_OK | MB_ICONWARNING );
		}break;
	case ID_40033:
		SetSubCalcRender( false );
		SetAddCalcRender( true );
		break;
	case ID_40034:
		SetSubCalcRender( true );
		SetAddCalcRender( false );
		break;

	default:
		break;

	}

}

// DirectX3D̏֐
HRESULT Init( HINSTANCE hInstance, HWND hWnd, BOOL bWindow )
{

	//DirectX9̐ݒ()
	//IDirect3DDevice9C^[tF[X̎擾


	D3DPRESENT_PARAMETERS d3dpp={0};			//foCX̓ݒ肷\
	D3DDISPLAYMODE d3ddm;						//fBXvC̐ݒ

	g_pD3D = Direct3DCreate9(D3D_SDK_VERSION);	//D3D9C^[tF[X̎擾
	if( g_pD3D==NULL ){
		return E_FAIL;
	}

	//݂̃foCX[h̎擾
	if(FAILED(g_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&d3ddm))){
		return E_FAIL;
	}

	//foCX̃v[e[Vp[^[̐ݒ
	ZeroMemory(&d3dpp,sizeof(d3dpp));

	d3dpp.BackBufferWidth=SCREEN_WIDTH;			//backbuffer̃TCY()
	d3dpp.BackBufferHeight=SCREEN_HEIGHT;		//backbuffer̃TCY(c)
	d3dpp.BackBufferFormat=d3ddm.Format;		//FULLSCREEN̂Ƃ͂̌ł͂ȂAWINDOWMODE͕
	d3dpp.BackBufferCount=1;					//backBuffer̐
	d3dpp.SwapEffect=D3DSWAPEFFECT_DISCARD;		//doubleBuffer̐؂ւ
	d3dpp.EnableAutoDepthStencil=TRUE;			//dv ;DepthStencil̎gp
	d3dpp.AutoDepthStencilFormat=D3DFMT_D16;	//D3DtH[}bg̐ݒ
	d3dpp.Windowed=bWindow;						//WindowMode trueŃEBhE falseFullScreen(WindowStylepopup)
	d3dpp.FullScreen_RefreshRateInHz
	=D3DPRESENT_RATE_DEFAULT;					//Xs[h(fullscreen̂Ƃ̂ݐݒ\)
	d3dpp.PresentationInterval
	=D3DPRESENT_INTERVAL_DEFAULT;				//fullscreen̎̂ 邩ǂ

	//Direct3DfoCX̐ݒ
	if(FAILED( g_pD3D->CreateDevice(
	D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
	D3DDEVTYPE_HAL,								//`揈type̎w(n[hł邩\tgł邩)HAL=n[h
	hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
	D3DCREATE_HARDWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓n[hEFAŒ_)
	&d3dpp,										//̑ݒ
	&g_pD3DDevice)))							//foCX̃|C^̃|C^
	//sNULLԂ
	{

		MessageBox(hWnd,"x܂","",MB_OK);
		if(FAILED( g_pD3D->CreateDevice(
		D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
		D3DDEVTYPE_HAL,								//`揈type̎w(n[hł邩\tgł邩)HAL=n[h
		hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
		D3DCREATE_SOFTWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓\tgEFAŒ_)
		&d3dpp,										//̑ݒ
		&g_pD3DDevice)))							//foCX̃|C^̃|C^
		{	

			if(FAILED( g_pD3D->CreateDevice(
			D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
			D3DDEVTYPE_REF,								//`揈type̎w(n[hł邩\tgł邩)
			hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
			D3DCREATE_SOFTWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓\tgEFAŒ_)
			&d3dpp,										//̑ݒ
			&g_pD3DDevice)))							//foCX̃|C^̃|C^
			{
				return E_FAIL;
			}
		}
	}

	// _\Xe[g̐ݒ
	//g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CW);			// v𗠖ʂƂ
	g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);			// v𗠖ʂƂ
	//g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);		// ʂ`悷

	g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);			// |Sŕ`
	//g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);	// |SC[t[ŕ`

	// ݉ʂɕ`ĂԂɂč`悷e
	g_pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);			// 
	g_pD3DDevice->SetRenderState(D3DRS_SRCBLEND,D3DBLEND_SRCALPHA);		// ̃
	g_pD3DDevice->SetRenderState(D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA);	// ̃(INV͋ẗӖ,ł̓l̋t)

	// eXg̐ݒ
	g_pD3DDevice->SetRenderState( D3DRS_ALPHATESTENABLE, FALSE );
	g_pD3DDevice->SetRenderState( D3DRS_ALPHAREF, 128 );
	g_pD3DDevice->SetRenderState( D3DRS_ALPHAFUNC, D3DCMP_GREATEREQUAL );

	// Tv[Xe[g̐ݒ(stagesteat texturestate)
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR);
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);
	//g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
	//g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);
	
	// eNX`Xe[g̐ݒ( ߏݒ )
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );

	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );


	// e֐̏
	CDebugManager::Create( ) ->Init( );
	InitKeyboard( hInstance, hWnd );
	InitMouse( hInstance, hWnd );
	InitCamera( );
	InitLight( );
	InitController( );
	InitShadow( );
	InitParticle( );
	InitModel( );
	InitField( );
	InitWall( );
	InitDome( );
	//InitPolygon( );
	//InitBillboard( );
	#ifdef _DEBUG
	InitDebug( );
	#endif

	//CreateMeshField( D3DXVECTOR3( -15, 0, 15 ), 10, 3 );
	//CreateMeshField( D3DXVECTOR3( -20, 0, 20 ), 10, 4 );
	CreateMeshFieldCenter( 10, 50 );
	CreateMeshWallCenter( 10, 50 );
	//CreateMeshFieldCenter( 3, 300, 10 );


	//
	return S_OK;
	
}

// I
void UnInit( void )
{

	// e֐̏I
	#ifdef _DEBUG
	UninitDebug( );
	#endif
	UninitShadow( );
	UninitParticle( );
	UninitField( );
	UninitWall( );
	UninitDome( );
	UninitModel( );
	UninitController( );
	UninitLight( );
	UninitCamera( );
	//UninitBillboard( );

	UninitMouse( );
	UninitKeyboard( );

	// fobO}l[W[̔j
	CDebugManager::ReleaseAll( );

	if(g_pD3DDevice!=NULL){

		g_pD3DDevice->Release();				// Direct3DDevicẻ
		g_pD3DDevice = NULL;					// cAhX
	}

	if(g_pD3D!=NULL){
		
		g_pD3D->Release();						// Direect3DC^[tF[X̉
		g_pD3D=NULL;							// cAhX
	}

}

// XV
void Update( void )
{


	// xvJn
	CDebugManager::IndexAccess(0) ->StartMeasureProcess( );

	// e֐̍XV
	UpdateKeyboard( );
	UpdateMouse( );

	UpdateShadow( );
	UpdateModel( );
	UpdateField( );
	UpdateWall( );
	UpdateDome( );
	UpdateController( );
	//UpdateBillboard( );
	UpdateParticle( );

	UpdateCamera( );
	UpdateLight( );

	#ifdef _DEBUG
	UpdateDebug( );
	#endif

	if( GetKeyboardTrigger( DIK_W ) && GetKeyboardPress( DIK_LCONTROL ) ){
		if( WIRE_FRAME ){
			WIRE_FRAME = false;
			g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);			//|Sŕ`
			//g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);	//|SC[t[ŕ`
		}
		else if( !WIRE_FRAME ){
			WIRE_FRAME = true;
			//g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);		//|Sŕ`
			g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);		//|SC[t[ŕ`
		}
	}

	// fobO}l[W[̍XV
	CDebugManager::UpdateAll( );

	// _CAO̍XV
	UpdateDlgEdit( );
	UpdatePtclPanelDlgEdit( );
	UpdateDomeDlgEdit( );


}
 
// `揈
void Draw ( void )
{

	// obNobt@Zobt@̃NA
	g_pD3DDevice->Clear(0,NULL,
	D3DCLEAR_TARGET								// F
	| D3DCLEAR_ZBUFFER,							// [x
	screenClearColor,							// NAF
	1.0f,										// NA[xl
	0);											// XeVl

	// `̊Jn
	if( SUCCEEDED( g_pD3DDevice ->BeginScene( ) )) {

		// e֐̕`揈
		//DrawWall( );
		DrawField( );
		DrawDome( );
		DrawShadow( );
		//DrawModel( );
		DrawParticle( );
		//DrawField( );

		// xvI
		CDebugManager::IndexAccess(0) ->EndMeasureProcess( );

		// fobO}l[W[̕`
		CDebugManager::DrawAll( );

		#ifdef _DEBUG
		DrawDebug( );
		#endif
		
		// `I
		g_pD3DDevice->EndScene( );
	}
	g_pD3DDevice->Present( NULL, NULL, NULL, NULL );

}

// Nt@Cǂݍݏ
void StartUpLoadFileProcess( LPTSTR IpCmdLine )
{


	// t@C̓ǂݍ݂ꍇ
	if( IpCmdLine[0] ){
	
		FILE* pfile;
		char filename[255] = { };		// t@Cl[
		char extension[255] ={ };		// gq
		char loadFile[255] = { };		// [ht@Cl[

		MessageBox( NULL, IpCmdLine, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );
		
		// t@C
		if( IpCmdLine[0] == '"' ){
			if( IpCmdLine[strlen( IpCmdLine )-1] == '"' ){
				sprintf( IpCmdLine, "%s", &IpCmdLine[1] );
				IpCmdLine[ strlen( IpCmdLine )-1 ] = '\0';
			}
		}

		MessageBox( NULL, IpCmdLine, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );

		// pX̐؂o
		_splitpath( IpCmdLine, NULL, NULL, filename, extension );
		
		// t@Cl[̏o
		sprintf( loadFile, "%s%s", filename , extension );

		MessageBox( NULL, loadFile, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );
		MessageBox( NULL, filename, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );
		MessageBox( NULL, extension, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );

		if( strcmp( extension, FORMAT_EMITTER[ 0 ] ) == 0 ){
		
		MessageBox( NULL, loadFile, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );

			// t@CI[v
			pfile = fopen( IpCmdLine , "rb" );
			if( !pfile ){
				MessageBox( NULL, "EMIITER LOAD ERROR !!", WINDOW_NAME, MB_OK | MB_ICONINFORMATION );
			}else{
				EMITTER* emitter = GetEmitter( );
				int      index   = GetEmitterIndex( );

				// EMITTERǂݍ
				fread( &emitter[index], sizeof( EMITTER ), 1, pfile );
				EmitterUpdateFrag( true );
				UpdateDlgEdit( );

				MessageBox( NULL, loadFile, WINDOW_NAME, MB_OK | MB_ICONINFORMATION );

			}
			fclose( pfile );
		}
	}

}

// hbOhbvꂽꍇ̏
void DropFileProcess( WPARAM wParam )
{

	FILE* pfile;
	HDROP hDrop = ( HDROP )wParam;
	TCHAR FILE_NAME[ 256 ] = {};
	TCHAR FULLPATH_FILE_NAME[ 256 ] = {};

	// hbOt@C̎擾
	::DragQueryFile( hDrop, 0, FULLPATH_FILE_NAME, sizeof( FULLPATH_FILE_NAME ) ); 

	// t@C
	char filename[255] = { };		// t@Cl[
	char extension[255] ={ };		// gq

	// pX̐؂o
	_splitpath( FULLPATH_FILE_NAME, NULL, NULL, filename, extension );
		
	// t@Cl[̏o
	sprintf(  FILE_NAME, "%s%s", filename , extension );
	int i = strlen( *FORMAT_EMITTER );

	// EMITTERFILE̓ǂݍ
	for( int index = 0; index < 1; index++ ){
		if( strcmp( extension, FORMAT_EMITTER[ index ] ) == 0 ){
		
			// t@CI[v
			pfile = fopen( FILE_NAME , "rb" );
			if( !pfile ){
				MessageBox(NULL, "EMIITER LOAD ERROR !!", WINDOW_NAME, MB_OK | MB_ICONINFORMATION );
				break;
			}
			EMITTER* emitter = GetEmitter( );
			int      index   = GetEmitterIndex( );

			// EMITTERǂݍ
			fread( &emitter[index], sizeof( EMITTER ), 1, pfile );
			EmitterUpdateFrag( true );
			fclose( pfile );
			UpdateDlgEdit( );
			::DragFinish( hDrop );
			return;
		}
	}

	// TEXTURE̓ǂݍ
	for( int index = 0; index < FORMAT_NUMBER; index++ ){
		if( strcmp( extension, FORMAT_TEXTURE[ index ] ) == 0 ){

			// eNX`[h
			TextureLoad( FULLPATH_FILE_NAME );
			::DragFinish( hDrop );
			return;
		}
	}

	// XFILE̓ǂݍ
	for( int index = 0; index < 1; index++ ){
		if( strcmp( extension, FORMAT_XFILE[ index ] ) == 0 ){

			// XFILE[h
			::DragFinish( hDrop );
			return;
		}
	}

	// hbOI
	::DragFinish( hDrop );


}

// foCX̎擾
LPDIRECT3DDEVICE9 GetDevice( void )
{

	return g_pD3DDevice;

}

// FPS̎擾
int GetFps( void )
{

	return g_nCountFPS;

}




